using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

namespace CellTree
{
	/// <summary>
	/// s[X̕`揇̕ύX̃TvtH[łB
	/// </summary>
	public class frmHeaderPrint : System.Windows.Forms.Form
	{
		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// Rg[łB
		/// </summary>
		public System.Windows.Forms.ToolTip tipInfo;
		public System.Windows.Forms.Button cmdPrintPreview;
		private AxKnTViewLib.AxKnTView KnTView1;
		public System.Windows.Forms.PictureBox picInfo;
		public System.Windows.Forms.TextBox txtInfo;
		public System.Windows.Forms.Label lblInfo;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.IContainer components;

		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmHeaderPrint));
			this.tipInfo = new System.Windows.Forms.ToolTip(this.components);
			this.cmdPrintPreview = new System.Windows.Forms.Button();
			this.KnTView1 = new AxKnTViewLib.AxKnTView();
			this.picInfo = new System.Windows.Forms.PictureBox();
			this.txtInfo = new System.Windows.Forms.TextBox();
			this.lblInfo = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.KnTView1)).BeginInit();
			this.SuspendLayout();
			// 
			// cmdPrintPreview
			// 
			this.cmdPrintPreview.BackColor = System.Drawing.SystemColors.Control;
			this.cmdPrintPreview.Cursor = System.Windows.Forms.Cursors.Default;
			this.cmdPrintPreview.ForeColor = System.Drawing.SystemColors.ControlText;
			this.cmdPrintPreview.Location = new System.Drawing.Point(8, 78);
			this.cmdPrintPreview.Name = "cmdPrintPreview";
			this.cmdPrintPreview.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.cmdPrintPreview.Size = new System.Drawing.Size(112, 20);
			this.cmdPrintPreview.TabIndex = 8;
			this.cmdPrintPreview.Text = "vr[(&P)";
			this.cmdPrintPreview.Click += new System.EventHandler(this.cmdPrintPreview_Click);
			// 
			// KnTView1
			// 
			this.KnTView1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.KnTView1.Location = new System.Drawing.Point(0, 112);
			this.KnTView1.Name = "KnTView1";
			this.KnTView1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("KnTView1.OcxState")));
			this.KnTView1.Size = new System.Drawing.Size(514, 196);
			this.KnTView1.TabIndex = 7;
			this.KnTView1.FooterPrint += new AxKnTViewLib._DKnTViewEvents_FooterPrintEventHandler(this.KnTView1_FooterPrint);
			this.KnTView1.HeaderPrint += new AxKnTViewLib._DKnTViewEvents_HeaderPrintEventHandler(this.KnTView1_HeaderPrint);
			// 
			// picInfo
			// 
			this.picInfo.BackColor = System.Drawing.SystemColors.Control;
			this.picInfo.Cursor = System.Windows.Forms.Cursors.Default;
			this.picInfo.ForeColor = System.Drawing.SystemColors.WindowText;
			this.picInfo.Image = ((System.Drawing.Bitmap)(resources.GetObject("picInfo.Image")));
			this.picInfo.Location = new System.Drawing.Point(467, 7);
			this.picInfo.Name = "picInfo";
			this.picInfo.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.picInfo.Size = new System.Drawing.Size(33, 33);
			this.picInfo.TabIndex = 10;
			this.picInfo.TabStop = false;
			this.picInfo.Click += new System.EventHandler(this.picInfo_Click);
			// 
			// txtInfo
			// 
			this.txtInfo.AcceptsReturn = true;
			this.txtInfo.AutoSize = false;
			this.txtInfo.BackColor = System.Drawing.SystemColors.Control;
			this.txtInfo.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.txtInfo.Cursor = System.Windows.Forms.Cursors.IBeam;
			this.txtInfo.ForeColor = System.Drawing.SystemColors.ControlText;
			this.txtInfo.Location = new System.Drawing.Point(9, 7);
			this.txtInfo.MaxLength = 0;
			this.txtInfo.Multiline = true;
			this.txtInfo.Name = "txtInfo";
			this.txtInfo.ReadOnly = true;
			this.txtInfo.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtInfo.Size = new System.Drawing.Size(451, 63);
			this.txtInfo.TabIndex = 9;
			this.txtInfo.Text = "^Cr[̈ɂāAwb_Atb_̕`sƂł܂B\r\n`ɂ WindowsAPI pKvL܂B\r\ñTvł͉L̋@\" +
				"Ă܂B\r\nEwb_Atb^̕`\r\nEs[Xo[̕`";
			// 
			// lblInfo
			// 
			this.lblInfo.BackColor = System.Drawing.SystemColors.Control;
			this.lblInfo.Cursor = System.Windows.Forms.Cursors.Default;
			this.lblInfo.ForeColor = System.Drawing.SystemColors.ControlText;
			this.lblInfo.Location = new System.Drawing.Point(459, 43);
			this.lblInfo.Name = "lblInfo";
			this.lblInfo.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.lblInfo.Size = new System.Drawing.Size(49, 15);
			this.lblInfo.TabIndex = 11;
			this.lblInfo.Text = "Click !";
			this.lblInfo.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// frmHeaderPrint
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(514, 309);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.cmdPrintPreview,
																		  this.KnTView1,
																		  this.picInfo,
																		  this.txtInfo,
																		  this.lblInfo});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Location = new System.Drawing.Point(4, 23);
			this.Name = "frmHeaderPrint";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "^Cr[ @\Љ - HeaderPrintCxg";
			((System.ComponentModel.ISupportInitialize)(this.KnTView1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// DrawText֐p萔łB
		/// </summary>
		private const int	DT_BOTTOM		= 0x8;
		private const int	DT_CENTER		= 0x1;
		private const int	DT_RIGHT		= 0x2;
		private const int	DT_VCENTER		= 0x4;
		private const int	DT_SINGLELINE	= 0x20;
		private const int	DT_TOP			= 0x0;

		/// <summary>
		/// CreateFont֐p萔łB
		/// </summary>
		private const int	SHIFTJIS_CHARSET	= 128;
		private const int	OUT_DEFAULT_PRECIS	= 0;
		private const int	CLIP_DEFAULT_PRECIS	= 0;
		private const int	DEFAULT_QUALITY		= 0;
		private const int	DEFAULT_PITCH		= 0;
		private const int	FF_DONTCARE			= 0;	//  Don't care or don't know.

		/// <summary>
		/// lp`̍ƉE̍W`܂BB
		/// </summary>
		public struct RECT
		{
			public int	left;
			public int	top;
			public int	right;
			public int	bottom;
		}

		/// <summary>
		/// DrawText֐(API)̃C|[głB
		/// </summary>
		[DllImport("User32.dll")]
		public static extern int DrawText(int hDC, string lpString, int nCount, ref RECT lpRect, int wFormat);

		/// <summary>
		/// CreateFont֐(API)̃C|[głB
		/// </summary>
		[DllImport("gdi32.dll")]
		public static extern int CreateFont(int nHeight, int nWidth, int nEscapement, int nOrientation, int fnWeight, int fdwItalic, int fdwUnderline, int fdwStrikeOut, int fdwCharSet, int fdwOutputPrecision, int fdwClipPrecision, int fdwQuality, int fdwPitchAndFamily, string lpszFace);

		/// <summary>
		/// SelectObject֐(API)̃C|[głB
		/// </summary>
		[DllImport("gdi32.dll")]
		public static extern int SelectObject(int hdc, int hgdiobj);

		/// <summary>
		/// DeleteObject֐(API)̃C|[głB
		/// </summary>
		[DllImport("gdi32.dll")]
		public static extern int DeleteObject(int hObject);

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmHeaderPrint());
		}

		/// <summary>
		/// RXgN^łB
		/// </summary>
		public frmHeaderPrint()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// tH[LoadCxgłB
		/// </summary>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		protected override void OnLoad(System.EventArgs e)
		{
			base.OnLoad(e);

			// \Œ
			KnTView1.ViewTopTime = DateTime.Now;

			// sp
			long	lngItemCounter;
	        
			for(lngItemCounter = 1; lngItemCounter <= 6; lngItemCounter++)
				KnTView1.Items.Add(null, null);

			// s[Xp
			SetupPiece(KnTView1.Items.Item(1).Pieces.Add(null, null), 1, KnTViewLib.TivLineStyle.tivLineDash);
			SetupPiece(KnTView1.Items.Item(2).Pieces.Add(null, null), 2, KnTViewLib.TivLineStyle.tivLineDashDot);
			SetupPiece(KnTView1.Items.Item(3).Pieces.Add(null, null), 3, KnTViewLib.TivLineStyle.tivLineDashDotDot);
			SetupPiece(KnTView1.Items.Item(4).Pieces.Add(null, null), 4, KnTViewLib.TivLineStyle.tivLineDot);
			SetupPiece(KnTView1.Items.Item(5).Pieces.Add(null, null), 5, KnTViewLib.TivLineStyle.tivLineNull);
			SetupPiece(KnTView1.Items.Item(6).Pieces.Add(null, null), 6, KnTViewLib.TivLineStyle.tivLineSolid);
		}

		/// <summary>
		/// ^Cr[FooterPrintCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void KnTView1_FooterPrint(object sender, AxKnTViewLib._DKnTViewEvents_FooterPrintEvent e)
		{
			// y[WJE^`
			int		fontPage;
			int		fontOld;
			string	strPage;
			RECT	rcPage;
	        
			// y[WJE^
			strPage = e.curPage.ToString() + " / " + e.numPages.ToString() + " y[W";
	        
			// y[WJE^`̈
			rcPage.left = e.left;
			rcPage.top = e.top;
			rcPage.right = e.right;
			rcPage.bottom = e.bottom;
	        
			// y[WJE^ptHg
			fontPage = CreateFont(12, 0, 0, 0, 0, 0, 0, 0, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "lr oSVbN");
	        
			// y[WJE^ptHgI
			fontOld = SelectObject(e.hdc, fontPage);
	        
			// y[WJE^`
			DrawText(e.hdc, strPage, -1, ref rcPage, DT_SINGLELINE | DT_BOTTOM | DT_RIGHT);

			// y[WJE^ptHgI
			SelectObject(e.hdc, fontOld);
	        
			// y[WJE^ptHg폜
			DeleteObject(fontPage);
		}

		/// <summary>
		/// ^Cr[HeaderPrintCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void KnTView1_HeaderPrint(object sender, AxKnTViewLib._DKnTViewEvents_HeaderPrintEvent e)
		{
			// ^Cg`
			int		fontOld;
			int		fontTitle;
			string	strTitle;
			RECT	rcTitle;
	        
			// ^Cg
			strTitle = base.Text;
	        
			// ^Cg`̈
			rcTitle.left	= e.left;
			rcTitle.top		= e.top + 40;
			rcTitle.right	= e.right;
			rcTitle.bottom	= e.bottom;
	        
			// ^CgptHg
			fontTitle = CreateFont(20, 0, 0, 0, 700, 0, 0, 0, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "lr oSVbN");
	        
			// ^CgptHgI
			fontOld = SelectObject(e.hdc, fontTitle);
	        
			// ^Cg`
			DrawText(e.hdc, strTitle, -1, ref rcTitle, 0);
	        
			// ^CgptHgI
			SelectObject(e.hdc, fontOld);
	        
			// ^CgptHg폜
			DeleteObject(fontTitle);


			// t`
			int		fontDate;
			string	strDate;
			RECT	rcDate;
	        
			// t
			strDate = ((DateTime)KnTView1.CurrentTime.Time).ToString("yyyyNMd");
	        
			// t`̈
			rcDate.left = e.left;
			rcDate.top = e.top;
			rcDate.right = e.right;
			rcDate.bottom = e.bottom;
	        
			// tptHg
			fontDate = CreateFont(12, 0, 0, 0, 0, 0, 0, 0, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "lr o");
	        
			// tptHgI
			fontOld = SelectObject(e.hdc, fontDate);
	        
			// t`
			DrawText(e.hdc, strDate, -1, ref rcDate, DT_SINGLELINE | DT_TOP | DT_RIGHT);
	        
			// tptHgI
			SelectObject(e.hdc, fontOld);
	        
			// tptHg폜
			DeleteObject(fontDate);


			// s[Xo[̕`
			const int		width	= 50;
			const int		height	= 10;
			int				intLeft;
			int				intTop;
	        
			intLeft = e.left + 395;
			intTop = e.top + 2;
	        
			foreach(KnTViewLib.Item	itemWork in KnTView1.Items){
				itemWork.Pieces.Item(1).DrawImage(e.hdc, intLeft, intTop, intLeft + width, intTop + height);
				intLeft = intLeft + 20;
				intTop = intTop + height + 2;
			}
		}

		/// <summary>
		/// vr[{^ClickCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void cmdPrintPreview_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.PrintInfo	info = new KnTViewLib.PrintInfo();
	        
			info.HeaderHeight = 2;
			info.FooterHeight = 1;
			info.StartTime = ((DateTime)KnTView1.ViewTopTime).AddHours(-15);
	        info.PaperSize = KnTViewLib.TivPaperSize.tivPaperA4;

			KnTView1.PrintPreview(info);
		}

		/// <summary>
		/// ACRClickCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void picInfo_Click(object sender, System.EventArgs e)
		{
			string strPrompt;

            strPrompt  = "Evr[{^ƁAvr[\\n";
            strPrompt += "@܂B\n";
            strPrompt += "Ewb_Ƀ^Cgƃs[Xo[Atb^Ƀy[W`悳\n";
            strPrompt += "@܂B";

			MessageBox.Show(strPrompt, "̃Tv̎g", MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		/// <summary>
		/// s[XZbgAbv܂B
		/// </summary>
		/// <param name="pieceWork">
		/// Ώۂ̃s[XB
		/// </param>
		/// <param name="hourStart">
		/// JnԂ̑ΈʒuB
		/// </param>
		/// <param name="lineStyle">
		/// C̃X^CB
		/// </param>
		private void SetupPiece(KnTViewLib.Piece pieceWork, long hourStart, KnTViewLib.TivLineStyle lineStyle)
		{
			// s[X
			pieceWork.Start		= ((DateTime)KnTView1.ViewTopTime).AddHours(hourStart);
			pieceWork.Finish	= ((DateTime)pieceWork.Start).AddHours(5);
			pieceWork.BarShape.Line.Style = lineStyle;
	        
			// LvV
			KnTViewLib.PieceCaption	pieceCaption;

			pieceCaption = pieceWork.Captions.Add(null, null);

			pieceCaption.Position = KnTViewLib.TivPieceCaptionPosition.tivPieceCenter;
			pieceCaption.HorAlign = KnTViewLib.TivTextHorAlign.tivTextHorAlignLeft;
	        
			switch(lineStyle){
			case KnTViewLib.TivLineStyle.tivLineDash:       pieceCaption.Text = "Dash";			break;
			case KnTViewLib.TivLineStyle.tivLineDashDot:    pieceCaption.Text = "DashDot";		break;
			case KnTViewLib.TivLineStyle.tivLineDashDotDot: pieceCaption.Text = "DashDotDot";	break;
			case KnTViewLib.TivLineStyle.tivLineDot:        pieceCaption.Text = "Dot";			break;
			case KnTViewLib.TivLineStyle.tivLineNull:       pieceCaption.Text = "Null";			break;
			case KnTViewLib.TivLineStyle.tivLineSolid:      pieceCaption.Text = "Solid";		break;
			}
		}
	}
}
